#include <iostream>
#include <vector>
#include <stdint.h>

[[gnu::hot]]
uint32_t msb(uint32_t n) noexcept {
	if (n == 0) return -1;
	uint32_t poz = 0;
	while((n = n >> 1))
		++poz;
	return poz;
	// clz je count leading zeroes, ako 
	// oduzmemo broj bitova u int32 dobijamo
	// poziciju ispred prve jedinice
}

constexpr int32_t MAX_N = 200010;
constexpr	int32_t MAX_BIT = 33;


int main() noexcept {
	std::ios::sync_with_stdio(false);
	std::cin.tie(nullptr);
	std::cout.tie(nullptr);
	std::cerr.tie(nullptr);

	std::vector<std::vector<uint32_t>> prefix;
	int64_t n, q, i, j, input, input_msb, l, r, k_max, k_curr;

	std::cin >> n >> q;
 	prefix = std::vector<std::vector<uint32_t>>(MAX_BIT, std::vector<uint32_t>(n, 0));

	for(i = 1; i <= n; ++i) {
		std::cin >> input;
		input_msb = msb(input);

		// uzimamo prethodne vrednosti iz prefix sume
		for(j = 0; j < MAX_BIT; ++j)
			prefix[j][i] = prefix[j][i-1];

		// brojimo frekvencije
		if (input_msb != -1) // provera za sve nule
			++prefix[input_msb][i];
	}

	while(q--) {
		std::cin >> l >> r;
		k_max = 0;

		for(j = 0; j < MAX_BIT; ++j) {
			k_curr = prefix[j][r] - prefix[j][l-1];
			k_max = (k_curr > k_max)? k_curr : k_max;
		}

		std::cout << k_max << '\n';
	}
}